*-------------------------------------------------------------------------------
/* title : Estimate and store TFP, output elasticites & Returns To Scale (RTS)
   input : $temp/Sample.dta;  and relevant code to estimate production function
		   $code/[4.2_sub] pf_estimation_${model}.do
   output: $output_dta/TFP_$model.dta */
*-------------------------------------------------------------------------------

preserve
	global rep = 0 									// Initialise # of bootstrap replication: 0 for original sample; >0 for any bootstrap sample
	
	* Production function estimation 
	run "$code/[4.2_sub] pf_estimation_${model}.do" // 1st Step: Non Linear Least Square of share equation; and 2nd Step: GMM of remaining pf parameters
	
	if "$compet"=="PC" 	keep id country $indlev year a_* RTS* *omega* rho_*
	else 				keep id country $indlev year a_* RTS* *omega* rho_* markup
	
	* Save
	compress
	save "$output_dta/TFP_$model.dta", replace
	
	* Summarise	
	noi sum a_* RTS omega*
	noi cap sum markup
restore
